function fs = randfs1(d,prop,nb)
%RANDFS1 RANDFS1 : a features subsets builder by sampling
%    with replacement
%    
%    FS = RANDFS1(D,PROP,NB) 
%    
%    FS   = cell array containing the subsets of features
%    D    = training set build with 'dataset'
%    PROP = percentage of the total number of attributes 
%    NB   = number of subsets
%     fs = randfs1(train,0.5,10);
%    data=get(train,'contdata');
%    d=data(:,fs{1});
%    See also: RANDFS2
%    
%    

%MAN_PAGE_BEGIN
%@purpose RANDFS1 : a features subsets builder by sampling with replacement
%@synopsis FS = RANDFS1(D,PROP,NB)
%@description <br>
%<br>
% <code>FS</code>   = cell array containing the subsets of features<br>
% <code>D</code>    = training set build with 'dataset'<br>
% <code>PROP</code> = percentage of the total number of attributes <br>
% <code>NB</code>   = number of subsets<br>
% @examples  fs = randfs1(train,0.5,10);<br>
%           data=get(train,'contdata');<br>
%           d=data(:,fs{1});<br>
%@see randfs2
%MAN_PAGE_END

%Contact Patrice Latinne for any help, 
%latinne@iridia.ulb.ac.be or 32-2-650.31.70


rand('state',sum(100*clock));
nv=get(d,'nv')-1;
nv2=ceil(prop*nv);  % fixed number of attributes
fs=cell(nb,1);

for i=1:nb
   fs{i} = sort(floor(1+nv*(rand(nv2,1))));  
end

