function m = external(varargin)
%EXTERNAL Constructor for the external class
%    
%    M=EXTERNAL creates a new general external skeleton.
%    
%    M=EXTERNAL(M) clone the external object M. This can be
%    also used to transform a structure in a external object
%    since the common fields are used to inizialize the
%    external object.
%    
%    M=EXTERNAL(NAME,N_IN,N_OUT)  creates a new general system
%    with N_IN inputs and N_OUT outputs. The name NAME is
%    associated to it.	
%    
%    The class defines the following methods:
%    
%      ADD_DYNAMICS: add the dynamical description of the
%          model
%      BUILD_REGRESSORS: build the regresors for a MIMO
%          system
%      CHECK: checks the consistency of all the fields of a
%          external object
%      DISPLAY: Display an object of class external
%      ERROR: computes the mean square error of the model
%      ERRORDB: Graphical User Interface for inspecting the
%          errors of the mappings
%      GET: gets the value of the attribute of an object
%      IDENTIFY: Identify the system from data
%      REGRESS: extracts the regressors from the data
%      SET: Set object properties
%      SIMULATE: simulates the model
%      SIMULATION_ERROR: computes the mean square error of
%          the simulated model
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  Constructor for the external class
%
%   @synopsis   m=external
%   @description  creates a new general external skeleton.
%
%   @synopsis   m=external(m)
%   @description  clone the external object <CODE>m</CODE>. This can be
%   also used to transform a structure in a external object since the
%   common fields are used to inizialize the external object.
%  
%   @synopsis m=external(name,n_in,n_out) 
%   @description creates a new general system with <CODE>n_in</CODE> inputs
%   and <CODE>n_out</CODE> outputs. The name <CODE>name</CODE> is associated
%   to it.       
%
%MAN_PAGE_END

% since this function is the constructor it is not necessary to perform
% any check on the object. Just check the consistency of the input values.  
  
error(checkargs(varargin,[0 3],'any','numeric','numeric'));
  
m=[];
%if no arguments build an emty object
if nargin==0                   
  m.dynamics=[];
  
  f=system;
  m=class(m,'external',f);
  
  %if one argument	
elseif nargin==1,              
  %if type internal clone it
  if isa(varargin{1},'external') & isa(varargin{1}.system ,'system'), 
    m=varargin{1};
    return
  %if type system add the fields    
  elseif isa(varargin{1},'system') & ~ isa(varargin{1},'external'),
    m.dynamics=[];
    
    f=varargin{1};
    m=class(m,'external',f);
  %if it is a structure (usually for update purposes)
  %try to recover all the common fields
  elseif isa(varargin{1},'struct')                                   
    m.dynamics=[];
    
    f=system;
    
    arg = struct(varargin{1});
    
    if isfield(arg,'system'),
      f = system(arg.system);
      arg = rmfield(arg,'system');
      
      fn=fieldnames(m);
      for i=1:size(fn,1),
	if isfield(arg,fn{i}),
	  m=setfield(m,fn{i},getfield(arg,fn{i}));
	end
      end  
    end
    
    m=class(m,'external',f);
  else  %it must be something odd
    error('wrong use of the constructor for the class external');
  end
  
  
elseif nargin>1,
  m.dynamics=[];
  
  f=system(varargin{:});

  m=class(m,'external',f);

  %clear the default values set by the system constructor 
  add_mapping(m);
  
end  




