function m = subsasgn(m,s,a)
%SUBSREF overloads the subscript reference operator
%    
%    

%_MAN_PAGE_BEGIN
%
%   @purpose  overloads the subscript reference operator.
%
%	@synopsis m.property = value
%	@description lets the user assign the value of a property using a classical assignation.
%	Assignations of the type m.property{subpart}.subpropertie(subsubpart) = something work as well.
%	Assignations of the type m{i) = something lets you access directly a mapping. 
%
%
%_MAN_PAGE_END     

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/06/98 14:46
%
%	All rights reserved

if (size(s,2)>1),
	val = subsref(m,s(1));
	val = subsasgn(val,s(2:end),a);
	m = subsasgn(m,s(1),val);
else
	if s(1).type=='.',
		set(m,s(1).subs,a);
	end
	
	if s(1).type=='{}',
	
		if length(s(1).subs) > 1,
			error('Please provide one dimensional index for mapping selection');
		end
	
		subs = s(1).subs{1};
		if (subs == ':'),
			subs = 1:size(m.mapping,2);
		end
		
		if length(subs)>1,
			error('Cannot assign values to more than one mapping at a time');
		end
		
		if subs>0,
			m.system.mapping{subs} = a;
		else
			m.statemapping{-subs} = a;
		end
	end
end
