function m = sets_grid(m, varargin)
%SETS_GRID Remove every fuzzy sets and replace them by
%    evenly spaced ones
%    
%    M = SETS_GRID(M, D1, D2, D3, D4..., T) places D1 sets of
%    type T along the dimension 1, D2 sets along the dimension
%    2, etc... The position of the sets is computed on the
%    basis of the limits attribute. The previously defined
%    rules and sets are removed.
%    
%    See also: ADD_SETSS
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Remove every fuzzy sets and replace them by evenly spaced ones
%
%   @synopsis	m = sets_grid(m, d1, d2, d3, d4..., t)
%   @description  places <CODE>d1</CODE> sets of type <CODE>t</CODE> along the dimension <CODE>1</CODE>,
%	<CODE>d2</CODE> sets along the dimension <CODE>2</CODE>, etc... The position of the
%	sets is computed on the basis of the limits attribute. The previously defined rules and
%	sets are removed.
%
%   @see add_setss
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/05/99

if ~ischar(varargin{nargin-1}),
	t = 'trapezoidal';
else
	t = varargin{nargin-1};
end

switch lower(t),
case 'constant',
code = 0;

case 'trapezoidal',
code = 1;

case 'gaussian',
code = 2;

case 's-shaped',
code = 3;

otherwise
error('Unrecognized rule type');
end

lims = get(m,'limits');
if ~all(all(finite(lims(:,1:get(m,'n_in'))))),
	error(['You first have to define every input limits before calling this function']);
end

for i=1:get(m,'n_in'),
	m = rem_sets(m,i);
	if varargin{i}>1,
		steps = (0:(1/(varargin{i} - 1)):1)' * (lims(2,i) - lims(1,i)) + lims(1,i);
		siz = (lims(2,i) - lims(1,i)) / (2 * varargin{i});
		m.mfs{i} = [code(ones(varargin{i},1),1) max(min([(steps - 2 * siz)  (steps - siz) (steps + siz) (steps + 2 * siz)], lims(2,i)),lims(1,i))];
	else
		steps = 0.5 * (lims(2,i) - lims(1,i)) + lims(1,i);
		m.mfs{i} = [code lims(1,i) steps steps lims(2,i)];
	end
	
	lnglst = {};
	cur = 'S';
	for j=1:floor(varargin{i}/2),
		lnglst = [{cur}; lnglst];
		cur = ['V' cur];
	end
	if varargin{i}/2 ~= floor(varargin{i}/2), lnglst = [lnglst; {'M'}]; end
	cur = 'B';
	for j=1:floor(varargin{i}/2),
		lnglst = [lnglst; {cur}];
		cur = ['V' cur];
	end
	m.ling{i} = lnglst;
	

end

if nargout == 0,
	assignin('caller',inputname(1),m)
end
