function out=jacob_inputs(m,r,j)
%JACOB_INPUTS computes the jacobian of the model
%    
%    The procedure for computing the jacobian depends on the
%    underlying representation  of the model. The result OUT
%    is an array of size number of outputs * number of inputs
%    containing the derivatives of the outputs with respect to
%    the inputs.
%    
%    JACOB_INPUTS(M,R,J) computes for output J the jacobian of
%    the model M with respect to the regressor of the system
%    at point R.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose    computes the jacobian of the model.
%   The procedure for computing the jacobian depends on the underlying representation 
%   of the model. The result <code>out</code> is an array of size number of outputs * number of inputs
%	containing the derivatives of the outputs with respect to the inputs.
%
%   @synopsis   jacob_inputs(m,r,j)
%   @description computes for output <CODE>j</CODE> the jacobian of
%  the model <CODE>m</CODE> with respect to the regressor of the
%  system at point <CODE>r</CODE>.
%
%MAN_PAGE_END

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved

error(checkargs([{m r j}],3,'system','numeric','numeric'));

%check(m);

out = jacob_inputs(m.mapping{m.links(j,1)},r,m.links(j,2));

