function m = fmclust_wrapper(m,in,out,options)
%FMCLUST_WRAPPER call fm_clust using information embedded
%    inside a taksug object
%    
%    FMCLUST_WRAPPER(M,IN,OUT,OPTIONS) 
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	call fm_clust using information embedded inside a taksug object
%
%   @synopsis	fmclust_wrapper(m,in,out,options)
%   @description  
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 17/05/99

Dat.U = in;
Dat.Y = out;

ni = get(m,'n_in');
no = get(m,'n_out');

Dyn.ny = zeros(no);
Dyn.nu = ones(no,ni);
Dyn.nd = zeros(no,ni);

if isfield(options,'n_rules'); Par.c = options.n_rules; else Par.c = 2; end;
if isfield(options,'rule_type'); Par.ante = rem(floor(options.rule_type/10),10); else Par.ante = 1; end;
if isfield(options,'fuzzyness'); Par.m = options.fuzzyness; else Par.m = 2; end;
if isfield(options,'tolerance'); Par.tol = options.tolerance; else Par.tol = 0.01; end;
if isfield(options,'seed'); Par.seed = options.seed; else Par.seed = sum(100*clock); end;

m = fromfm(fmclust(Dat, Par, Dyn), m);

if isfield(options,'type'); m = set(m,'model_code',options.type); end;
