fprintf('\n')
fprintf('NLMIMO TUTORIAL 1: identification of a sine wave\n')
fprintf('\n')
fprintf('The aim of this tutorial is to show how to carry out the\n');
fprintf('identification process of a simple static function\n');
fprintf('\n')
fprintf('First it is necessary to create an input output system which\n')
fprintf('uses and external representation\n')
fprintf('\n')
fprintf('>> sm=external(''sin'',1,1);\n');
sm=external('sin',1,1)
pause
fprintf('\n')
fprintf('Set the dynamics of the static system\n\n')
fprintf('>> sm=add_dynamics(sm,0,1,0);\n\n');
fprintf('Which means that the output ifs functions of 0 past outputs\n')
fprintf('and 1 input which as a delay of 0\n')
sm=add_dynamics(sm,0,1,0);
pause
fprintf('\n')
fprintf('\n')
fprintf('Then it is necessary to attaches the data to the input and output\n') 
fprintf('of the model. In this case the data associated to the input is a\n') 
fprintf('linear progression from 1 to 10 while the output is a sine wave\n')  
fprintf('evaluated on the same interval\n')
fprintf('\n')
fprintf('>> d=dataset([(1:0.01:10)'' sin(1:0.01:10)'']);\n')
fprintf('>> sm=add_data(sm,d);\n')
fprintf('\n')
fprintf('First the data  is create and passed to an object of type data\n')
fprintf('and then attached to the object\n')
d=dataset([(1:0.01:10)' sin(1:0.01:10)']);
sm=add_data(sm,d);
pause
fprintf('\n')
fprintf('Now it is time to define the mappings of the system, the nonlinear\n')
fprintf('functions which given and input regressor produce the output of\n')
fprintf('the system\n\n')
fprintf('>> sm_mapping=taksug(''linear fitting mapping'',1,1);\n');
sm_mapping=taksug('fmclust mapping',1,1)
fprintf('which is a mapping with one input and one output\n\n');
pause
fprintf('\n')
fprintf('Attach the mapping to the system and create the link output\n');
fprintf('of the system, the mapping and the output of the mapping\n\n');
fprintf('>> sm=add_mapping(sm,sm_mapping);\n');
fprintf('>> set(sm,''links'',[1 1]);\n\n');
sm=add_mapping(sm,sm_mapping);
set(sm,'links',[1 1]);
pause
fprintf('\n')
fprintf('Perform an identification of output 1 using the\n');
fprintf('''fmclust'' algorithm which is based on a GK clustering developed\n');
fprintf('at the university of Delft\n\n');
fprintf('>> sm=identify(sm,1,struct(''method'',''fmclus'',''n_rules'',6))\n');
sm=identify(sm,1,struct('method','fmclust','n_rules',6));
pause
fprintf('\n')
fprintf('Clone te fist output of the system and link it with the first\n');
fprintf('output\n\n')
fprintf('>> sm=clone_output(sm,1,''cluslms mapping'')\n');
sm=clone_output(sm,1,'cluslms mapping');
pause
fprintf('Perform an identification of output 1 using the\n');
fprintf('''cluslms'' algorithm which is based on a GK clustering developed\n');
fprintf('at the university Bruxelles\n\n');
fprintf('>> sm=identify(sm,1,struct(''method'',''cluslms'',''n_rules'',6))\n');
sm=identify(sm,1,struct('method','cluslms','n_rules',6));
pause
fprintf('Clone the first output and perform an identification of output 1\n');
fprintf('using the ''cluslev'' algorithm which is based on a GK clustering\n');
fprintf('and LM optimization developed at the university Bruxelles\n\n');
fprintf('>> sm=clone_output(sm,1,''cluslev mapping'')\n');
fprintf('>> sm=identify(sm,1,struct(''method'',''cluslev'',''n_rules'',6))\n');
sm=clone_output(sm,1,'cluslev mapping')
sm=identify(sm,1,struct('method','cluslev','n_rules',6));
pause
fprintf('Clone the first output and perform an identification of output 1\n');
fprintf('using the ''randlm'' algorithm which is based on a random placement\n');
fprintf('of the centers of the rules and a LM optimization developed at the\n');
fprintf('university Bruxelles\n\n');
fprintf('>> sm=clone_output(sm,1,''randlm mapping'')\n');
fprintf('>> sm=identify(sm,1,struct(''method'',''randlm'',''n_rules'',6))\n');
sm=clone_output(sm,1,'randlm mapping')
sm=identify(sm,1,struct('method','randlm','n_rules',6));
pause
fprintf('Perform an identification of output 1 using the incremental \n');
fprintf('''tsgklmsxv'' algorithm which is based on a GK clustering \n');
fprintf('followed by a LMS optimization and xvalidation of the linears\n');
fprintf('developed at the university Bruxelles\n\n');
fprintf('>> sm=clone_output(sm,1,''tsgklmsxv mapping'')\n');
fprintf('>> sm=identify(sm,1,struct(''method'',''tsgklmsxv'',''min_n_rules'',2,''max_n_rules'',10))\n');
sm=clone_output(sm,1,'tsgklmsxv mapping')
sm=identify(sm,1,struct('method','tsgklmsxv','min_n_rules',2,'max_n_rules',10));
pause
fprintf('Then plot the resulting system with all the mappings\n\n');
fprintf('>> plot(sm);\n');
plot(sm);
pause
