function export(d,name)
%EXPORT Export a data set to a comma delimited text file
%    
%    EXPORT(D,NAME) export the dataset D to file named NAME.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Export a data set to a comma delimited text file
%
%   @synopsis	export(d,name)
%   @description  export the dataset <CODE>d</CODE> to file named <CODE>name</CODE>.
%
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 24/03/99

fid = fopen(name,'w');
for i=1:size(d,1);
	fprintf(fid,'%8.7f,',get_data(i,1:d.nv-1));
	fprintf(fid,'%8.7f',get_data(i,d.nv));
	fprintf(fid,'\n');
end
fclose(fid);
