function [out,theRest]=pick(d,n)
%PICK picks randomly chosen examples out of a data set
%    
%    [OUT,THEREST]=PICK(D,N) picks N randomly chosen example
%    out of dataset D. The picked examples are rturned inside
%    OUT, the others are inside THEREST. %
%    
%    See also: CUT
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	picks randomly chosen examples out of a data set
%
%   @synopsis	[out,theRest]=pick(d,n)
%   @description  picks <code>n</code> randomly chosen example out of
%	dataset <code>d</code>. The picked examples are rturned inside <code>out</code>,
%	the others are inside <code>theRest</code>.
%%
%   @see cut
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

select=[];
select = randperm(size(d,1));
select=sort(select(1:n));
restsel=setdiff(1:size(d,1),select);

tref.type='()';

tref.subs={select ':'};
out=subsref(d,tref);

tref.subs={restsel ':'};
theRest=subsref(d,tref);

