function out=size(d,n)
%SIZE get the size of the data set
%    
%    OUT=SIZE(D) returns the dimensions (number of examples,
%    number of variables) of the database D.
%    
%    OUT=SIZE(D,N) returns either the number of examples(N =
%    1) or the number of variables(N = 2) of the database D.
%    
%    See also: ALSO GET
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	get the size of the data set
%
%   @synopsis	out=size(d)
%   @description  returns the dimensions (number of examples,
%	number of variables) of the database <code>d</code>.
%
%   @synopsis	out=size(d,n)
%   @description  returns either the number of examples(<code>n</code> = 1)
%	or the number of variables(<code>n</code> = 2) of the database <code>d</code>.
%
%
%   @see also get
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 18/03/99

if nargin==1,
	out = [d.ns d.nv];
elseif nargin == 2,
	if n == 1,
		out = d.ns; 
	elseif n == 2,
		out = d.nv;
	end
else
out=[];
end
