function i3 = glob_indice(m, c, y_d, v, limits)
%GLOB_INDICE Compute the third stability indice for a
%    closed loop
%    
%    [I1,I2] = GLOB_INDICE(M, C, Y_D, V, LIMITS) M is the
%    model (external) and C is the controller. Y_D is the
%    desired output and V are the perturbations.
%    
%    See also: LOCAL_INDICE
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Compute the third stability indice for a closed loop
%
%   @synopsis	[i1,i2] = glob_indice(m, c, y_d, v, limits)
%   @description  <CODE>m</CODE> is the model (external) and <CODE>c</CODE> is
%	the controller. <CODE>y_d</CODE> is the desired output and <CODE>v</CODE> are
%	the perturbations.
%
%   @see local_indice
%
%MAN_PAGE_END

n = get(m,'n_state') + get(c,'n_state');
x = [get(m,'state') get(c,'state')];

minval = realmax;

for i = 1:n,
	for j = 0:10,
		xt = x;
		xt(i) = xt(i) + (limits(1,i) + (limits(2,i) - limits(1,i)) / 10 * j);
		vv = glob_indice_loc_cost(xt, m, c, y_d, v);
		if vv < minval,
			minval = vv;
			savx = xt;
			flag = j;
			direct = i;
		end
		xt = x;
		xt(i) = xt(i) - (limits(1,i) + (limits(2,i) - limits(1,i)) / 10 * j);
		vv = glob_indice_loc_cost(xt, m, c, y_d, v);
		if vv < minval,
			minval = vv;
			savx = xt;
			flag = j;
			direct = -i;
		end
	end
end

if flag,
	lims = x([1 1],:) + [-limits(2,:);limits(2,:)];
	if direct>0,
		lims(:,direct) = x([1 1],direct) + limits(:,direct);
	else
		lims(:,-direct) = x([1 1],-direct) - flipud(limits(:,-direct));
	end
	
	opt = foptions;
	
	[x, opt] = hkconstr('glob_indice_loc_cost',savx,opt,lims(1,:),lims(2,:),[],m,c,y_d,v);
	i3 = opt(8);
else
	i3 = minval;
end
