function [i1, i2] = loc_indices(m, c, y_d, v, eq_m, eq_c)
%LOC_INDICES Compute the first and the second stability
%    indices for a closed loop
%    
%    [I1,I2] = LOC_INDICES(M,C,YD,V,EQ_M,EQ_C) M is the model
%    (external) and C is the controller. Y_D is the desired
%    output and V are the perturbations.
%    
%    See also: GLOB_INDICE
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Compute the first and the second stability indices for a closed loop
%
%   @synopsis	[i1,i2] = loc_indices(m,c,yd,v,eq_m,eq_c)
%   @description  <CODE>m</CODE> is the model (external) and <CODE>c</CODE> is
%	the controller. <CODE>y_d</CODE> is the desired output and <CODE>v</CODE> are
%	the perturbations.
%
%   @see glob_indice
%
%MAN_PAGE_END

if nargin> 4,
	set(m,'state',eq_m);
end

if nargin> 5,
	set(c,'state',eq_c);
end

J = jacob_cloop(m, c, y_d, v);

n = get(m,'n_state') + get(c,'n_state');

i1 = ((-1)^n) * det(J);

if nargout > 1,
	p = poly(J);
	
	t = zeros(2,n);
	
	%Compute the Hurwitz matrix
	
	H = zeros(n);
	
	t(1:n+1) = p;
	t = flipud(t);
	
	k=0;
	for i=1:2:n,
		k=k+1;
		if (i < n),
			H([i i+1],k:n) = t(:,1:n-(k-1));
		else
			H(i,k:n) = t(1,1:n-(k-1));
		end
	end
	
	i2=det(H)/i1;
end
