function out=jacob_params(m,varargin)
%JACOB_PARAMS computes the jacobian of the model
%    
%    This function does not have  any meaning for lazy
%    systems, and it is provided only for compatibility
%    reasons.
%    
%    JACOB_PARAMS(M,X)   computes for each output the jacobian
%    of the model with respect to the parameters at input X.
%    It returns an empty array.
%    
%    JACOB_PARAMS(M,X,J)   computes for output(s) J the
%    jacobian of the model with respect to the parameters at
%    input REGRESSOR. It returns an empty array.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the jacobian of the model. This function does not have 
%   any meaning for lazy systems, and it is provided only for compatibility
%   reasons.
%
%   @synopsis jacob_params(m,x)  
%   @description computes for each output the jacobian of
%  the model with respect to the parameters at input <CODE>x</CODE>.
%  It returns an empty array.
%
%   @synopsis jacob_params(m,x,j)  
%   @description computes for output(s) <CODE>j</CODE> the jacobian of
%  the model with respect to the parameters at input <CODE>regressor</CODE>.
%  It returns an empty array.
%
%
%MAN_PAGE_END    


%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved


error(checkargs([{m} varargin],[2 3],'lazy','numeric','numeric'));

check(m);

out=[];
