function out=eval(m,varargin)
%EVAL computes the value of the linear for some input
%    
%    OUT=EVAL(M,REGRESSOR,J) returns the value OUT of the
%    output(s) J of linear M given the input(s) X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the value of the linear for some input.
%   
%   @synopsis out=eval(m,regressor,j)
%   @description  returns the value <code>out</code> of the output(s) <code>j</code> of
%   linear <code>m</code> given the input(s) <code>x</code>.
%
%MAN_PAGE_END

error(checkargs([{m} varargin],[2 3],'linear','numeric','numeric'));

x = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

out = [x ones(size(x,1),1)] * m.linears(j,:)';


