function out=jacob_inputs(m,varargin)
%JACOB_INPUTS computes the jacobian of the model
%    
%    The result OUT is an array of size number of outputs *
%    number of inputs containing the derivatives of the
%    outputs with respect to the inputs.
%    
%    JACOB_INPUTS(M,X) computes for each output the jacobian
%    of the model with respect to the x (the input of the
%    lookup) at point X.
%    
%    JACOB_INPUTS(M,X,J) computes for output J the jacobian of
%    the model with respect to the x (the input of the lookup)
%    at point X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose    computes the jacobian of the model.
%   The result <code>out</code> is an array of size number of outputs * number of inputs
%	containing the derivatives of the outputs with respect to the inputs.
%
%   @synopsis   jacob_inputs(m,x)
%   @description computes for each output the jacobian of
%  the model with respect to the x (the input of the
%  lookup) at point <CODE>x</CODE>.
%
%   @synopsis   jacob_inputs(m,x,j)
%   @description computes for output J the jacobian of
%  the model with respect to the x (the input of the
%  lookup) at point <CODE>x</CODE>.
%
%MAN_PAGE_END

%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved

error(checkargs([{m} varargin],[2 3],'lookup','numeric','numeric'));

check(m);

x = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

opt = get(m,'opt');

if ~isfield(opt,'dlookups'),
	[pin,pout] = lookup_jac(x',m.lookups,m.scales{:});

	out = [pin' ones(size(pin,2),1)] \ pout';
	out = out(1:end-1)';
else
	for i=1:get(m,'n_in'),
		out(i) = lookup_out(x',opt.dlookups{i},opt.dscales{:});
	end
end
