function out=jacob_params(m,varargin)
%JACOB_PARAMS computes the jacobian of the model
%    
%    JACOB_PARAMS(M,X)   computes for each output the jacobian
%    of the model with respect to the parameters at input X.
%    
%    JACOB_PARAMS(M,X,J)   computes for output(s) J the
%    jacobian of the model with respect to the parameters at
%    input X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the jacobian of the model.
%
%   @synopsis jacob_params(m,x)  
%   @description computes for each output the jacobian of
%  the model with respect to the parameters at input <CODE>x</CODE>.
%
%   @synopsis jacob_params(m,x,j)  
%   @description computes for output(s) <CODE>j</CODE> the jacobian of
%  the model with respect to the parameters at input <CODE>x</CODE>.
%
%
%MAN_PAGE_END    


%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved


error(checkargs([{m} varargin],[2 3],'lookup','numeric','numeric'));

check(m);

x = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

out = zeros(length(j),(get(m,'n_in')+1)*get(m,'n_out'));

for i=1:length(j),
	out(i,(j(i)-1)*(get(m,'n_in')+1)+1:j(i)*(get(m,'n_in')+1)) =[x 1];
end

get(m,'optimparams')

out = out(:,get(m,'optimparams'));
