function m = add_sets(m,i,n,t)
%ADD_SETS Add fuzzy sets along one or more dimension of
%    the space
%    
%    M = ADD_SETS(M,I,N,T) adds N sets to the dimension I of
%    the Mamdani Function M. The sets are of type t Accepted
%    values for T are 'constant, 'trapezoidal','gaussian' and
%    's-shaped'.
%    
%    M = ADD_SETS(M,I,N,T) where N where n is a cell array of
%    linguistic values attaches the corresponding sets to the
%    dimension <CODE>i<CODE>.
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Add fuzzy sets along one or more dimension of the space
%
%   @synopsis	m = add_sets(m,i,n,t)
%   @description  adds <CODE>n</CODE> sets to the dimension <CODE>i</CODE>
%	of the Mamdani Function <CODE>m</CODE>. The sets are of type t
%	Accepted values for <CODE>t</CODE> are 'constant, 'trapezoidal','gaussian'
%	and 's-shaped'.
%
%   @synopsis	m = add_sets(m,i,n,t)
%   @description  where <CODE>n</CODE> where n is a cell array of linguistic
%	values attaches the corresponding sets to the dimension <CODE>i<CODE>.
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/05/99

if nargin<4,
	t = 'trapezoidal';
end

error(checkargs({m i n t},4,'mamdani','numeric','numeric','char'));

switch lower(t),
case 'constant',
code = 0;

case 'trapezoidal',
code = 1;

case 'gaussian',
code = 2;

case 's-shaped',
code = 3;

otherwise
error('Unrecognized rule type');
end

if iscell(n),
	m.mfs{i} = [m.mfs{i}; repmat([code 0 0 0 0],[length(n) 1])];
	m.ling{i} = [m.ling{i};n(:)];
else
	m.mfs{i} = [m.mfs{i}; repmat([code 0 0 0 0],[n 1])];
	
	[lnglst{:}] = deal('noname');
	m.ling{i} = [m.ling{i};lnglst(:)];
end

if nargout == 0,
	assignin('caller',inputname(1),m)
end
