function m=denormalize(m)
%DENORMALIZE denormalises the model
%    
%    This function  can be applied to denormalise a model that
%    has been previously  normalised with the function
%    NORMALISE restoring the original shape of the local
%    representation of the model.
%    
%    M=DENOMALISE(M) denormalzes the model M.
%    
%    See also: NORMALIZE
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose    denormalises the model. This function 
%   can be applied to denormalise a model that has been previously 
%   normalised with the function <code>normalise</code>
%   restoring the original shape of the local representation of the
%   model.
%
%   @synopsis   m=denomalise(m)
%   @description  denormalzes the model <code>m</code>.
%
%   @see normalize
%
%MAN_PAGE_END  


%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 12:02
%
%	All rights reserved

check(m);

n_in = get(m,'n_in');
n_out = get(m,'n_out');

m.mapping = denormalise(m.mapping);

limits = get(m,'limits');

theMinIn = limits(1,1:n_in)';
theMinOut = limits(1,n_in+1:n_in+n_out)';
theMaxIn = limits(2,1:n_in)';
theMaxOut = limits(2,n_in+1:n_in+n_out)';

NI = diag(1./(theMaxIn-theMinIn));

f2 = theMaxOut - theMinOut;
f3 = theMaxIn - theMinIn;

for i = 1:n_in,
	m.mfs{i}(:,2:end) = m.mfs{i}(:,2:end) * f3(1,i) + theMinIn(1,i);
end

for i = 1:n_out,
	m.mfs{n_in+i}(:,2:end) = (m.mfs{n_in+i}(:,2:end) * f4(1,i) + theMinOut(1,i);
end

