function [MeanError,MaxError] = ModelResults(Models)
%*******************************************************************************%
% File : ModelResult.m
% Last update: 15/10/98
% Author : SIEMENS\Dominique PASSAQUAY
% Subject: Visualize of the fuzzy model results 
%*******************************************************************************%
% [MeanError,MaxError] = ModelResults(Models)
%   Models is a struct array where each element (i) is defined with the following structure:
%    MeanErrorOutput          ... mean error for each output obtained with the ith fuzzy model
%    MeanError                ... mean error obtained with the ith fuzzy model
%    MaxErrorOutput           ... max error for each output obtained with the ith fuzzy model
%    MaxError                 ... max error obtained with the ith fuzzy model
%    Model                    ... ith fuzzy model

 MeanErrorOutput=[];
 MeanError=[];
 MaxErrorOutput=[];
 MaxError=[];
 for ind=1:size(Models,2)
  MeanErrorOutput=[MeanErrorOutput;Models(ind).MeanErrorOutput];
  MeanError=[MeanError;Models(ind).MeanError];
  MaxErrorOutput=[MaxErrorOutput;Models(ind).MaxErrorOutput];
  MaxError=[MaxError;Models(ind).MaxError];
 end
 [MinMeanError,ModelMeanError]=min(MeanError);
 [MinMaxError,ModelMaxError]=min(MaxError);
 figure;
 subplot(2,1,1);
 title('Select the complexity');
 hold on;

 if Models(1).Model.NbOutput>1
  for Output=1:Models(1).Model.NbOutput
   plot([1:size(Models,2)],MeanErrorOutput(:,Output),'g--');
  end
 end
 plot([1:size(Models,2)],MeanError);

 plot(ModelMeanError,MinMeanError,'ro');
 plot(ModelMaxError,MeanError(ModelMaxError),'g+');
ylabel('\epsilon_{mean}','VerticalAlignment','middle','HorizontalAlignment','Right','FontSize',12,'FontName','Courier New', ...
       'Rotation',0);
 zoom on;
 subplot(2,1,2);
 title('Select the complexity');
 hold on;

 if Models(1).Model.NbOutput>1
  for Output=1:Models(1).Model.NbOutput
   plot([1:size(Models,2)],MaxErrorOutput(:,Output),'g--');
  end
 end
 plot([1:size(Models,2)],MaxError);

 plot(ModelMaxError,MinMaxError,'ro');
 plot(ModelMeanError,MaxError(ModelMeanError),'g+');
xlabel('Nb_{rules}','VerticalAlignment','middle','HorizontalAlignment','center','FontSize',12,'FontName','Courier New');
ylabel('\epsilon_{max}','VerticalAlignment','middle','HorizontalAlignment','Right','FontSize',12,'FontName','Courier New', ...
       'Rotation',0);
 zoom on;
 [MinMeanError,ModelMeanError]=min(MeanError);
%  MeanError=MinMeanError;
%  MaxError=MinMaxError;
 fprintf('Model with the lowest mean error is %2d (%2.3f)\n',ModelMeanError,MeanError);
 fprintf('Model with the lowest max  error is %2d (%2.3f)\n',ModelMaxError,MaxError);
%*******************************************************************************%
