function m=split_rule(m,j,theSplittedRuleID,theSplittedRule,theLine,theNumChildren);

n_rules=m.description{j}.n_rules;
dim = size(m.description{j}.centers,1);

theOrigC=m.description{j}.opt.PSCenters(1:dim,-theSplittedRuleID);
theOrigIVar=projclus(inv(m.description{j}.opt.PSVars(:,:,-theSplittedRuleID)),(1:dim)');

theFinalC=m.description{j}.centers(:,theSplittedRule);
theFinalIVar=m.description{j}.ivariances(:,:,theSplittedRule);

[theOrigRot,theOrigHom]=eig(theOrigIVar);
theOrigHom=sqrt(theOrigHom);
theOrigRot=(theOrigRot*det(theOrigRot))';
theOrigM=theOrigHom*theOrigRot;

[theFinalRot,theFinalHom]=eig(theFinalIVar);
theFinalHom=sqrt(theFinalHom);
theFinalRot=(theFinalRot*det(theFinalRot))';
theFinalM=theFinalHom*theFinalRot;

for i=1:theNumChildren,
	theChildID(i)=m.description{j}.opt.Hierarchy(theLine,i+1);
	if theChildID(i)>0,
		theNewOldC(:,i)=m.description{j}.opt.PNCenters(1:dim,theChildID(i));
		theNewOldIV(:,:,i)=projclus(inv(m.description{j}.opt.PNVars(:,:,theChildID(i))),(1:dim)');
	else
		theNewOldC(:,i)=m.description{j}.opt.PSCenters(1:dim,-theChildID(i));
		theNewOldIV(:,:,i)=projclus(inv(m.description{j}.opt.PSVars(:,:,-theChildID(i))),(1:dim)');
	end;
	theNewNewC(:,i)=theFinalC-inv(theFinalM)*theOrigM*(theOrigC-theNewOldC(:,i));
	theNewNewIV(:,:,i)=theFinalM'*inv(theOrigM)'*theNewOldIV(:,:,i)*inv(theOrigM)*theFinalM;
end;

m=add_rules(m,theNumChildren-1,{'productspace' 'inversedist' 'linear'},j);
m.description{j}.centers(:,end-theNumChildren+2:end)=theNewNewC(:,2:theNumChildren);
m.description{j}.ivariances(:,:,end-theNumChildren+2:end)=theNewNewIV(:,:,2:theNumChildren);
m.description{j}.opt.IDs=[m.description{j}.opt.IDs theChildID(:,2:theNumChildren)];
m.description{j}.centers(:,theSplittedRule)=theNewNewC(:,1);
m.description{j}.ivariances(:,:,theSplittedRule)=theNewNewIV(:,:,1);
m.description{j}.opt.IDs(:,theSplittedRule)=theChildID(:,1);
