function m=rem_rules(m,n)
%REM_RULES remove the specified rules from the mamdani
%    object
%    
%    M=REM_RULES(M) remove all rules from model M.
%    
%    M=REM_RULES(M,N) remove rules number N from model M.
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	remove the specified rules from the mamdani object
%
%   @synopsis	m=rem_rules(m)
%   @description  remove all rules from model <CODE>m</CODE>.
%
%   @synopsis	m=rem_rules(m,n)
%   @description  remove rules number <CODE>n</CODE> from model <CODE>m</CODE>.
%
%   @see 
%
%MAN_PAGE_END



%   @synopsis add_rules(m,n)  
%   @description add <code>n</code> rules to the model <code>m</code>.
%
%   @synopsis add_rules(m,n,model_code)  
%   @description  add <CODE>n</CODE> rules to the model <CODE>m</CODE>, <CODE>model_code</CODE> is 
%   a cell array of three elements {x y z} where x is the type of the antecedents 
%   ('product space', 'projected'), y is the type of the membership functions 
%   ('gaussian', 'inversedist': 1/dist_mahal(1/(m-1))) and z is the type of the consequents 
%   ('linear').
%

if nargin<2,
	n = [];
end

error(checkargs({m n},2,'mamdani','numeric'));

%check for consistency
check(m);
 
if isempty(n),
  	m.rls = [];
  	m.n_rules = 0;
  	m.model_code = {};
else
	m.rls(n,:) = [];
  	m.n_rules = m.n_rules - length(n);
end  	
