function m=rem_sets(m,i,n)
%REM_SETS remove the specified sets from the mamdani
%    object
%    
%    M=REM_SETS(M,I) remove all sets from output i of model M.
%    
%    M=REM_SETS(M,I,N) remove sets number N from output i of
%    model M.
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	remove the specified sets from the mamdani object
%
%   @synopsis	m=rem_sets(m,i)
%   @description  remove all sets from output i of model <CODE>m</CODE>.
%
%   @synopsis	m=rem_sets(m,i,n)
%   @description  remove sets number <CODE>n</CODE> from output i of model <CODE>m</CODE>.
%
%   @see 
%
%MAN_PAGE_END



%   @synopsis add_sets(m,n)  
%   @description add <code>n</code> sets to the model <code>m</code>.
%
%   @synopsis add_sets(m,n,model_code)  
%   @description  add <CODE>n</CODE> sets to the model <CODE>m</CODE>, <CODE>model_code</CODE> is 
%   a cell array of three elements {x y z} where x is the type of the antecedents 
%   ('product space', 'projected'), y is the type of the membership functions 
%   ('gaussian', 'inversedist': 1/dist_mahal(1/(m-1))) and z is the type of the consequents 
%   ('linear').
%

if nargin<3,
	n = [];
end


error(checkargs({m n},2,'mamdani','numeric'));

%check for consistency
check(m);
 
if isempty(n),
  	m.mfs{i} = [];
  	m.ling{i} = {};
else
	m.mfs{i}(n,:) = [];
  	m.ling{i}(n) = [];
end  	
