function check(m); 
%CHECK checks the consistency of all the field of a
%    mapping object
%    
%    This function has been provided in order to make the
%    mapping class more robust since it checks a mapping
%    object for consistency of the data defined in its fields.
%    If a inconsistency is found, an  error message is
%    displayed.
%    
%    CHECK(M) check the consistency of a mapping object.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose checks the consistency of all the field of a mapping object.
%   This function has been provided in order to make the mapping class
%   more robust since it checks a mapping object for consistency of
%   the data defined in its fields. If a inconsistency is found, an 
%   error message is displayed.
%
%   @synopsis check(m)
%   @description  check the consistency of a mapping object.
%
%MAN_PAGE_END

error(checkargs({m},1,'mapping'));
sm=struct(m);

if ~isfield(sm,'date'),
	error('object MAPPING should have a ''date'' attribute');
end
if ~isfield(sm,'n_in'),
	error('object MAPPING should have a ''n_in'' attribute');
end
if ~isfield(sm,'n_out'),
	error('object MAPPING should have a ''n_out'' attribute');
end
if ~isfield(sm,'limits'),
	error('object MAPPING should have a ''limits'' attribute');
end
if ~isfield(sm,'opt'),
	error('object MAPPING should have a ''opt'' attribute');
end
if ~isfield(sm,'userData'),
	error('object MAPPING should have a ''userdata'' attribute');
end
if ~isfield(sm,'name'),
	error('object MAPPING should have a ''name'' attribute');
end

if ~isfield(sm,'optimparams'),
	error('object MAPPING should have a ''optimparams'' attribute');
end


% Check the consistency between the limits field and the number of inputs/outputs
if m.n_in < 0,
	error('The number of inputs must be positive');
end

if m.n_out < 0,
	error('The number of outputs must be positive');
end

if (~isempty(m.limits)) &  (size(m.limits,1) ~= 2),
	error('object MAPPING should have a ''limits'' attribute with 2 rows');
end

if (~isempty(m.limits)) & (size(m.limits,2) ~= (m.n_in + m.n_out)),
	error(['This object should have a ''limits'' attribute with ' num2str(m.n_in + m.n_out) ' columns']);
end

if (~isempty(m.limits))
	for j=1:m.n_in+m.n_out,
		if m.limits(1,j)>m.limits(2,j),
			error('inconsistent values in the field ''limits''');
		end
	end	
end
