function out=flat_error(m,in,out,varargin)
%ERROR Computes the squared error of the mapping
%    
%    OUT=ERROR(M,IN,OUT) for each output, the mean squared
%    error is computed, comparing predictions made on th basis
%    of inputs IN to reference outputs OUT.
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Computes the squared error of the mapping
%
%   @synopsis	out=error(m,in,out)
%   @description  for each output, the mean squared error is computed,
%	comparing predictions made on th basis of inputs <CODE>in</CODE> to
%	reference outputs <CODE>out</CODE>.
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 21/08/99



error(checkargs([{m in out} varargin],[3 4],'mapping','numeric','numeric','numeric'));

args = [{m in} varargin];
out = sum((eval(args{:}) - out).^2)';
