function d=get(m,label)
%GET gets the value of the attribute of an object
%    
%    D = GET(M,LABEL,OPT) gets the value of the attribute
%    LABEL associated to the object M and return it inside D.
%    The following codes are recognised:
%    
%      NAME: returns the name of the object
%      N_IN: returns the number of inputs of the mapping
%      N_OUT: returns the number of outputs of the mapping
%      USERDATA: returns the 'userData' field
%      OPT: returns the 'opt' field
%      DATE: returns the date of creation of the object
%      LIMITS: returns the limits of the mapping
%      OPTIMPARAMS: returns the indices of the parameters to
%          be optimised
%      NUMPARAMS: returns the number of parameters to be
%          optimised
%    
%    See also: SET
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  gets the value of the attribute of an object.
%
%   @synopsis	d = get(m,label,opt)
%   @description gets the value of the attribute <code>label</code>
%   associated to the object <code>m</code> and return it inside <code>d</code>.
%	The following codes are recognised:
%<dl>
%<dt>		name  <dd>	returns the name of the object
%<dt>     n_in  <dd>      	returns the number of inputs of the mapping
%<dt>     n_out  <dd>     	returns the number of outputs of the mapping
%<dt>			userData <dd>		returns the 'userData' field
%<dt>			opt			 <dd>		returns the 'opt' field
%<dt>			date		 <dd>		returns the date of creation of the object
%<dt>	 limits	 <dd>				returns the limits of the mapping
%<dt>	 optimparams	 <dd>		returns the indices of the parameters to be optimised
%<dt>	 numparams	 <dd>		returns the number of parameters to be optimised
%</dl>
%
%   @see set
%
%MAN_PAGE_END   

error(checkargs({m label},2,'mapping','char'));

check(m);

switch upper(label),
	
	case 'NAME',
		d=m.name;
		
	case 'N_IN',
		d=m.n_in;
		
	case 'N_OUT',
		d=m.n_out;
		
	case 'USERDATA',
		d=m.userData;
		
	case 'OPT',
		d=m.opt;
		
	case 'DATE',
		d=m.date;
		
	case 'LIMITS',
		d=m.limits;
		
	case 'OPTIMPARAMS',
		d=m.optimparams;	
	
	case 'NUMPARAMS',
		d=length(m.optimparams);	
	otherwise 
        error ('mapping/get: attibute requested not recognized'); 	
		
end
	
		
