function m=add_mapping(m,varargin)
%ADD_MAPPING add a mapping to a system object
%    
%    This method adds a mapping to the list of the current
%    mappings of the system object. The links field, which
%    connects the mapping with the output, must be set using
%    the SET method. 
%    
%    M=ADD_MAPPING(M) clears the mapping field of the object
%    
%    M=ADD_MAPPING(M,{MAPPING}) adds the mapping MAPPING to
%    the current mapping description. 
%    
%    

%MAN_PAGE_BEGIN
%
%		@purpose add a mapping to a system object. This method adds a mapping to
%		the list of the current mappings of the system object. The links
%		field, which connects the mapping with the output, must be set using
%		the <code>set</code> method. 
%
%		@synopsis		m=add_mapping(m)
%		@description clears the mapping field of the object
%
%		@synopsis		m=add_mapping(m,{mapping})
%		@description adds the mapping <code>mapping</code> to the current
%		mapping description.	
%
%MAN_PAGE_END
	
%if only one argument is given: clear all
if	nargin == 1,
	m.mapping={};
	m.links=[];
else
	for i=1:nargin-1,
		error(checkval(varargin{i},'mapping','the new mapping'));
		if isempty(m.mapping),
			set(m,'mapping',varargin(i));
%Antoine I do not like the following line, it is messy.		 
%		 set(m,'links',[ones(m.n_out,1) (1:m.n_out)']);
		else
			set(m,'mapping',[m.mapping varargin(i)]);
		end
	end
end	 

if nargout == 0,
	assignin('caller',inputname(1),m)
end
