function m=denormalize(m)
%DENORMALIZE denormalizes the model
%    
%    This function  can be applied to denormalize a model that
%    has been previously  normalised with the function
%    NORMALIZE restoring the original shape of the local
%    representation of the model.
%    
%    M=DENOMALISE(M) denormalzes the model M.
%    
%    See also: NORMALIZE
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose    denormalizes the model. This function 
%   can be applied to denormalize a model that has been previously 
%   normalised with the function <code>normalize</code>
%   restoring the original shape of the local representation of the
%   model.
%
%   @synopsis   m=denomalise(m)
%   @description  denormalzes the model <code>m</code>.
%
%   @see normalize
%
%MAN_PAGE_END  


%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 13/09/98 12:02
%
%	All rights reserved

check(m);

n_in = get(m,'n_in');
n_out = get(m,'n_out');

m.mapping = denormalise(m.mapping);

limits = get(m,'limits');

theMinIn = limits(1,1:n_in)';
theMinOut = limits(1,n_in+1:n_in+n_out)';
theMaxIn = limits(2,1:n_in)';
theMaxOut = limits(2,n_in+1:n_in+n_out)';

NI = diag(1./(theMaxIn-theMinIn));

f2 = theMaxOut - theMinOut;
f3 = theMaxIn - theMinIn;
f4 = f3(:,ones(n_out,1))' ./ f2(:,ones(n_in,1));

if strcmpi(m.model_code{1},'productspace')
	for i = 1:m.n_rules,
		f1 = theMinOut + squeeze(m.linears(1,1:n_in,i)) * theMinIn;
		
		m.linears(:,n_in+1,i) = m.linears(:,n_in+1,i) .* f2 + f1;
		m.linears(:,1:n_in,i) = m.linears(:,1:n_in,i) ./ f4;
		m.centers(:,i) = m.centers(:,i) .* f3 + theMinIn;
		m.ivariances(:,:,i) = NI * m.ivariances(:,:,i) * NI;
	end
else
	for i = 1:m.n_rules,
		f1 = theMinOut + squeeze(m.linears(1,1:n_in,i)) * theMinIn;
		
		m.linears(:,n_in+1,i) = m.linears(:,n_in+1,i) .* f2 + f1;
		m.linears(:,1:n_in,i) = m.linears(:,1:n_in,i) ./ f4;
	end
	for i = 1:n_in,
		m.mfs{i}(:,2:end) = m.mfs{i}(:,2:end) * f3(1,i) + theMinIn(1,i);
	end
end




