function out=eval(m,varargin)
%EVAL computes the value of the model
%    
%    This function returns the output of system as computated
%    by the model, given  a regressor. 
%    
%    OUT=EVAL(M,X,J) returns the value OUT for the output(s) J
%    of model M given the input X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the value of the model. This function
%   returns the output of system as computated by the model, given 
%   a regressor. 
%   
%   @synopsis out=eval(m,x,j)
%   @description  returns the value <code>out</code> for the output(s) <code>j</code> of
%   model <code>m</code> given the input <code>x</code>.
%
%MAN_PAGE_END

%    version 1.0
%
%  Antoine Duchateau, 10/12/1997
%


error(checkargs([{m} varargin],[2 3],'taksug','numeric','numeric'));

x = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end


switch m.model_code{1},
case 'productspace',
	if strcmpi(m.model_code{2},'gaussian'),
		out = out_mex(x',m.centers, m.ivariances,m.linears(j,:,:),1)';
	elseif strcmpi(m.model_code{2},'inversedist'),
		out = out_mex(x',m.centers, m.ivariances,m.linears(j,:,:),1,2,m.m)';
	elseif strcmpi(m.model_code{2},'ungaussian'),
		out = out_mex(x',m.centers, m.ivariances,m.linears(j,:,:),0)';
	elseif strcmpi(m.model_code{2},'uninversedist'),
		out = out_mex(x',m.centers, m.ivariances,m.linears(j,:,:),0,2,m.m)';
	end
		 
case 'projected',
    f = membership(m,x)';
    sf = sum(f,2) + realmin;
    out = zeros(size(x,1),get(m,'n_out'));
    lx = [x ones(size(x,1),1)];
    for i=1:get(m,'n_rules'),
    	out = out + f(:,i*ones(get(m,'n_out'),1)) .* (lx * m.linears(j,:,i)');
    end
    out = out ./ sf(:,ones(get(m,'n_out'),1));
    
otherwise,
end

