function m=set_rule_grid_define_all(m,varargin);
%SET_RULE_GRID_DEFINE_ALL: this function is designed to create a grid of rules: contered in the points specified, the rules are inizialized: with the PRODUCTSPACE,  INVERSEDIST and   LINEAR attributes
%    
%    LINEAR attributes. The density of the grid is the same
%    for all the outputs. 
%    
%    M=SET_RULE_GRID(M,[RANGE_OUTPUT_1],..,[RANGE_OUTPUT_N],[RANGE_INPUT_N],..[RANGE_INPUT_M]) add to the model M a gird of rules
%    centered in the points specified by the RANGE vectors.
%    The number of these vectors must be equal to <code>num_inputs+num_outputs</code>.
%    
%    

%_MAN_PAGE_BEGIN
%
%   @purpose sets a grid of rules. This function is designed to create a grid of rules
%   centered in the points specified, the rules are inizialized
%   with the <code>productspace</code>,  <code>inversedist</code> and  
%   <code>linear</code> attributes. The density of the grid is the same
%   for all the outputs. 
%
%   @synopsis m=set_rule_grid(m,[range_output_1],..,[range_output_n],[range_input_n],..[range_input_m])
%   @description  add to the model <code>m</code> a gird of rules
%   centered in the points specified by the <code>range</code> vectors.
%   The number of these vectors must be equal to <code>num_inputs+num_outputs</code>.
%
%_MAN_PAGE_END
  
n_inputs=get(m,'n_in');
n_outputs=get(m,'n_out');   

if nargin < n_inputs+1, error('Error, insufficient number of arguments'); end
if nargin > n_inputs+1, error('Error, too many arguments'); end

centers=[];
for j=1:nargin-1, 
  xx=centers;
  yy=varargin{j};
  nx=size(xx,2);
  ny=size(yy,2);
  %repeat and tail the coordinates of the centers
  xx = repmat(xx,1,ny);
  yy=reshape(repmat(yy,nx,1),nx*ny,1)';
  %update the centers
  if isempty(centers),
    centers=varargin{j};
  else  
    centers=[xx;yy];
  end  
end


numb_rules=size(centers,2);
m=rem_rules(m);
m=add_rules(m,numb_rules,{'productspace' 'inversedist' 'linear'});
set(m,'centers',...
      centers,... 
      'ivariances', ...
      repmat(eye(n_inputs),[1,1,numb_rules]),...
      'linears',...
      zeros(n_outputs,n_inputs+1,numb_rules));


for i=1:n_inputs,
  m.ivariances(i,i,:)=m.ivariances(i,i,:)*length(varargin{i});
end
