function f=sys2mv(w,a,b,c,d)
%
% SYS2MV Numerator/Denominator to MVFR
%
%   SYS2MV(w,NUM,DEN) returns the multivariable
%   frecuency respose of the LTI continuous-time
%   multivariable system defined by numerator NUM 
%   and denominator DEN. W is the associted frecuency
%   vector.
%       If the Transfer Matrix has m x n elements,
%       NUM has m rows and lenght(DEN)*n columns.
%       Each row is divided into n sets of length(DEN)
%       corresponding to the differents inputs. So,
%       each row contains the transfer elements of
%       each input: NUM=[n11,n12,n13...;n21,n22,...;...]
%       DEN is the minimum commom denominator.  
%
%   SYS2MV(w,A,B,C,D) returns the multivariable
%   frecuency respose of the LTI continuous-time
%   multivariable system defined by A,B,C,D.
%   W is the associted frecuency vector.
%
% See also dsys2mv, descfunc, fdly_nl, matfreqs

%-----------------------------------------------------
% Departamento de Ingenieria de Sistemas y Automatica.
% Universidad de Sevilla 
%-----------------------------------------------------
% File: sys2mv
% Project: FAMIMO
% Block: fast
% Use: 
%-----------------------------------------------------
% toolbox used: control and fast
%
%-----------------------------------------------------
% Authors: Francisco M. Lopez Rodriguez and J.J. Murillo
% E-mail : pacolope@bart.us.es ( ambar@sitrantor.es )
%          murillo@cartuja.us.es
% Date:  Oct 1997
%-----------------------------------------------------
% System : matlab 4.2c or higher
%      simulink 1.3a or higher
%-----------------------------------------------------
% If you have any question please contact us :
% plopez@cartuja.us.es 
%-----------------------------------------------------


narg=nargin;
nargchk(3,5,narg);

if (narg==5)
    [num,den]=ss2tm(a,b,c,d);
else
    num=a;
    den=b;
    
end        

[OutputSize,elements]=size(num);

longDen=length(den);

if elements>longDen
   InputSize=elements/longDen;
else
   InputSize=1;
end


f=zeros(length(w)*OutputSize,InputSize);

for k=1:length(w)
    
    for k1=1:OutputSize
        for k2=1:InputSize
            
            numxx=num(k1,(((k2-1)*longDen)+1):(k2*longDen));
            [re,im]=hknyquist(numxx,den,w(k));
            g=re+j*im;
            f(((k-1)*OutputSize)+k1,k2)=g;
        end
    end
end
