function ante = antename(FM)
% ANTENAME    extract names of antecedent variables from FM.
%     ANTE = ANTENAME(FM) is a cell array of cell arrays
%     containing the names of all antecedent variables
%     in the fuzzy model FM.
%
%  See also FM2TEX, PLOTMFS, FMSTRUCT

% (c) Robert Babuska, 1997-98

ny = FM.ny;
nu = FM.nu;
nd = FM.nd;
NI = FM.ni;
NO = FM.no;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% define strings for input and output names
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(FM.InputName);
   inpvar = FM.InputName;
else
   if NI == 1,
      inpvar = 'u';
   else
      for j = 1 : NI, inpvar{j} = ['u_' num2str(j)]; end;
   end;
end;
if ~isempty(FM.OutputName);
   outvar = FM.OutputName;
else
   if NO == 1,
      outvar = 'y';
   else
      for j = 1 : NO, outvar{j} = ['y_' num2str(j)]; end;
   end;
end;

%%%%%%%%%% loop for all outputs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for k = 1 : NO,
   ii = 1;
   if NO == 1,
      for i = 1 : ny,
         if i == 1, vars{ii} = [outvar '(k)'];
         else vars{ii} = [outvar '(k-' num2str(i-1) ')']; end;
         ii = ii + 1;
      end;
   else
      for j = 1 : NO,
         for i = 1 : ny(k,j),
            if i == 1, vars{ii} = [outvar{j} '(k)'];
            else vars{ii} = [outvar{j} '(k-' num2str(i-1) ')']; end;
            ii = ii + 1;
         end;
      end;
   end;
   
   if NI == 1,
      for i = nd : nu+nd-1,
         if all(ny(k,:) == 0),
            vars{ii} = inpvar;
         else
            if i == 0, vars{ii} = [inpvar '(k+1)'];
            elseif i == 1, vars{ii} = [inpvar '(k)'];
            else vars{ii} = [inpvar '(k-' num2str(i-1) ')']; end;
         end;   
         ii = ii + 1;
      end;
   else
      for j = 1 : NI,
         for i = nd(k,j) : nu(k,j)+nd(k,j)-1,
            if all(ny(k,:) == 0),
               vars{ii} = inpvar{j};
            else
               if i == 0, vars{ii} = [inpvar{j} '(k+1)'];
               elseif i == 1, vars{ii} = [inpvar{j} '(k)'];
               else vars{ii} = [inpvar{j} '(k-' num2str(i-1) ')']; end;
            end;   
            ii = ii + 1;
         end;
      end;
   end;
   ante{k} = vars;
end;
