function redraw_hook(forced);
if nargin<1, forced=0; end

which_button = find(btnstate(gcf,'Main_Panel'));
params = get(gcf,'UserData');

if forced|(params.current_state~=which_button),	  %Adjust the panel
	clf
	
	switch which_button,
		case 1,
			x_hook = draw_data(params);
		case 2,
			x_hook = draw_dynamics(params);
		case 3,
			x_hook = draw_identification(params);
		case 4,
			x_hook = draw_visualisation(params);
		case 5,
			x_hook = draw_control(params);
		case 6,
			x_hook = draw_stability(params);
	end
	
	h1 = uicontrol('Parent',gcf, ...
		'Units','normal', ...
		'Callback','save_config_hook', ...
		'BackgroundColor',[1 1 1]*0.7, ...
		'HorizontalAlignment','Center', ...
		'Position',[0.44 0.52 0.15 0.06], ...
		'String','Save Config.', ...
		'Style','push', ...
		'Tag','push_load');
	
	h1 = uicontrol('Parent',gcf, ...
		'Units','normal', ...
		'Callback','load_config_hook', ...
		'BackgroundColor',[1 1 1]*0.7, ...
		'HorizontalAlignment','Center', ...
		'Position',[0.62 0.52 0.15 0.06], ...
		'String','Load Config.', ...
		'Style','push', ...
		'Tag','push_load');
	
	h1 = uicontrol('Parent',gcf, ...
		'Units','normal', ...
		'Callback',x_hook, ...
		'BackgroundColor',[1 1 1]*0.7, ...
		'HorizontalAlignment','Center', ...
		'Position',[0.82 0.52 0.15 0.06], ...
		'String','Apply', ...
		'Style','push', ...
		'Tag','push_ok');
	
	params.current_state=which_button;
end
	
set(gcf,'UserData',params);

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'ForegroundColor',[0.5 0.5 0.5], ...
	'Position',[0.23 0.01 0.76 0.48], ...
	'Style','frame', ...
	'Tag','Frame1');

h = uicontrol('Style','Text',...
		'Units','normal', ...
		'HorizontalAlignment','Left', ...
		'BackgroundColor',[1 1 1]*0.9, ...
		'Position',[0.25 0.03 0.72 0.44]);

info_text = {['Model type:' class(params.m)],
             ['Input data size:',mat2str(size(get(params.m,'data_in')))],
             ['Output data size:',mat2str(size(get(params.m,'data_out')))]};

[outstring,newpos] = textwrap(h,info_text);    %nice text wrapping
pos(4) = newpos(4);
set(h,'String',outstring)    %binds the text with the canvass for the text
	
	
function x_hook = draw_data(params)

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'ForegroundColor',[0.5 0.5 0.5], ...
	'Position',[0.23 0.5 0.76 0.49], ...
	'Style','frame', ...
	'Tag','Frame1');
	
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'HorizontalAlignment','Left', ...
	'Position',[0.25 0.91 0.2 0.05], ...
	'String','Data File:', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.92 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook', ...         %calls back for saving the params
	'String',params.data, ...           %saves the inputs in a variable for later use
	'Tag','data');

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'Callback','browse_hook', ...
	'BackgroundColor',[1 1 1]*0.7, ...
	'HorizontalAlignment','Center', ...
	'Position',[0.36 0.92 0.1 0.05], ...
	'String','Browse', ...
	'Style','push', ...
	'Tag','push_browse');
	
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.84 0.2 0.05], ...
	'String','Input Variable(s):', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.85 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook;', ...
	'String',params.input, ...
	'Tag','input');

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.77 0.2 0.05], ...
	'String','Output Variable(s):', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.78 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook;', ...
	'String',params.output, ...
	'Tag','output');
	
help_text = 'Type the name of the data file and the name of the variables containing the data. Leave the "Data File" field blank if you want the variables to be taken from memory.';
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.60 0.72 0.15], ...
	'String',help_text, ...
	'Style','text', ...
	'Tag','StaticText1');

x_hook = 'execute_hook;update_matrices_hook;';

function x_hook = draw_dynamics(params)

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'ForegroundColor',[0.5 0.5 0.5], ...
	'Position',[0.23 0.5 0.76 0.49], ...
	'Style','frame', ...
	'Tag','Frame1');
	
	
ni = get(params.m,'n_in');
no = get(params.m,'n_out');

if (ni>0)&(no>0),
	if iscell(params.ny),
		h1 = uicontrol('Parent',gcf, ...
			'Units','normal', ...
			'BackgroundColor',[1 1 1]*0.8, ...
			'HorizontalAlignment','Left', ...
			'Position',[0.25 0.91 0.2 0.05], ...
			'String','ny (nb. of outputs):', ...
			'Style','text', ...
			'Tag','StaticText1');
		
		h1 = uicontrol('Parent',gcf, ...
			'Units','normal', ...
			'HorizontalAlignment','Left', ...
			'BackgroundColor',[1 1 1]*0.8, ...
			'Position',[0.5 0.91 0.2 0.05], ...
			'String','nu (nb. of inputs):', ...
			'Style','text', ...
			'Tag','StaticText1');
			
		h1 = uicontrol('Parent',gcf, ...
			'Units','normal', ...
			'HorizontalAlignment','Left', ...
			'BackgroundColor',[1 1 1]*0.8, ...
			'Position',[0.75 0.91 0.2 0.05], ...
			'String','nd (inp. delays):', ...
			'Style','text', ...
			'Tag','StaticText1');
		
		for i=1:no,
			for j=1:no,
				h1 = uicontrol('Parent',gcf, ...
				'BackgroundColor',[1 1 1], ...
				'Units','normal', ...
				'HorizontalAlignment','Left', ...
				'Position',[0.26+0.04*(j-1)+0.02*(4-no) 0.85-0.055*(i-1) 0.035 0.054], ...
				'Style','edit', ...
				'Callback',['edit_hook_table(' num2str(i) ', ' num2str(j) ')'], ...
				'String',params.ny{i,j}, ...
				'Tag','ny');
			end
		end
		
		for i=1:no,
			for j=1:ni,
				h1 = uicontrol('Parent',gcf, ...
				'BackgroundColor',[1 1 1], ...
				'Units','normal', ...
				'HorizontalAlignment','Left', ...
				'Position',[0.49+0.04*(j-1)+0.02*(5-ni) 0.85-0.055*(i-1) 0.035 0.054], ...
				'Style','edit', ...
				'Callback',['edit_hook_table(' num2str(i) ', ' num2str(j) ')']', ...
				'String',params.nu{i,j}, ...
				'Tag','nu');
			end
		end
		
		for i=1:no,
			for j=1:ni,
				h1 = uicontrol('Parent',gcf, ...
				'BackgroundColor',[1 1 1], ...
				'Units','normal', ...
				'HorizontalAlignment','Left', ...
				'Position',[0.74+0.04*(j-1)+0.02*(5-ni) 0.85-0.055*(i-1) 0.035 0.054], ...
				'Style','edit', ...
				'Callback',['edit_hook_table(' num2str(i) ', ' num2str(j) ')'], ...
				'String',params.nd{i,j}, ...
				'Tag','nd');
			end
		end
	else	% Cannot use the nice presentation
		h1 = uicontrol('Parent',gcf, ...
			'Units','normal', ...
			'BackgroundColor',[1 1 1]*0.8, ...
			'HorizontalAlignment','Left', ...
			'Position',[0.25 0.91 0.2 0.05], ...
			'String','ny (nb. of outputs):', ...
			'Style','text', ...
			'Tag','StaticText1');
		
		h1 = uicontrol('Parent',gcf, ...
			'Units','normal', ...
			'HorizontalAlignment','Left', ...
			'BackgroundColor',[1 1 1]*0.8, ...
			'Position',[0.25 0.81 0.2 0.05], ...
			'String','nu (nb. of inputs):', ...
			'Style','text', ...
			'Tag','StaticText1');
			
		h1 = uicontrol('Parent',gcf, ...
			'Units','normal', ...
			'HorizontalAlignment','Left', ...
			'BackgroundColor',[1 1 1]*0.8, ...
			'Position',[0.25 0.71 0.2 0.05], ...
			'String','nd (inp. delays):', ...
			'Style','text', ...
			'Tag','StaticText1');
			
		h1 = uicontrol('Parent',gcf, ...
				'BackgroundColor',[1 1 1], ...
				'Units','normal', ...
				'HorizontalAlignment','Left', ...
				'Position',[0.46 0.91 0.5 0.06], ...
				'Style','edit', ...
				'Callback','edit_hook', ...
				'String',params.nu, ...
				'Tag','nu');
				
		h1 = uicontrol('Parent',gcf, ...
				'BackgroundColor',[1 1 1], ...
				'Units','normal', ...
				'HorizontalAlignment','Left', ...
				'Position',[0.46 0.81 0.5 0.06], ...
				'Style','edit', ...
				'Callback','edit_hook', ...
				'String',params.ny, ...
				'Tag','ny');

		h1 = uicontrol('Parent',gcf, ...
				'BackgroundColor',[1 1 1], ...
				'Units','normal', ...
				'HorizontalAlignment','Left', ...
				'Position',[0.46 0.71 0.5 0.06], ...
				'Style','edit', ...
				'Callback','edit_hook', ...
				'String',params.nd, ...
				'Tag','nd');
	end
end
	
	
	
help_text = 'Type the dynamical description into the fields. Leave all fields blank for a static mapping.';
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.60 0.72 0.08], ...
	'String',help_text, ...
	'Style','text', ...
	'Tag','StaticText1');
	
	
x_hook = 'execute_hook;';
	
function x_hook = draw_identification(params)

which_model = find(btnstate(gcf,'Model_Panel'));

switch which_model,
	case 1,
		menus=strvcat('Clustering + LMS','Fmclust (Delft)','Increm. (Siemens)','Clus. + Lev.-Mar.','Random + Lev.-Mar.');
		help_text = 'Choose an identification method from the popup menu and enter the parameters into the corresponding field';
	case 2,
		menus='';
		help_text = 'Type the parameters into the corresponding field.';
	case 3,
		menus='';
		help_text = 'Type the parameters into the corresponding field. The em algorithm is used to perform the identification. (This feature is yet to be implemented)';
end

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'ForegroundColor',[0.5 0.5 0.5], ...
	'Position',[0.23 0.5 0.76 0.49], ...
	'Style','frame', ...
	'Tag','Frame1');
	
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'HorizontalAlignment','Left', ...
	'Position',[0.25 0.91 0.2 0.05], ...
	'String','Ident. method:', ...
	'Style','text', ...
	'Tag','StaticText1');
	
if ~isempty(menus),
	h1 = uicontrol('Parent',gcf, ...
		'BackgroundColor',[1 1 1], ...
		'Units','normal', ...
		'HorizontalAlignment','Left', ...
		'Position',[0.47 0.92 0.5 0.05], ...
		'String',menus, ...
		'Style','popup', ...
		'Callback','popup_hook', ...
		'Value',params.method, ...
		'Tag','method');
else
	h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.91 0.2 0.05], ...
	'String','Standard', ...
	'Style','text', ...
	'Tag','StaticText1');
end

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.84 0.2 0.05], ...
	'String','Parameters:', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.85 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook', ...
	'String',params.ident_params, ...
	'Tag','ident_params');

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.60 0.72 0.15], ...
	'String',help_text, ...
	'Style','text', ...
	'Tag','StaticText1');

x_hook = 'execute_hook;';

function x_hook = draw_visualisation(params)

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'ForegroundColor',[0.5 0.5 0.5], ...
	'Position',[0.23 0.5 0.76 0.49], ...
	'Style','frame', ...
	'Tag','Frame1');
	
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'HorizontalAlignment','Left', ...
	'Position',[0.25 0.91 0.2 0.05], ...
	'String','Data set:', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.92 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook', ...
	'String',params.xval_data, ...
	'Tag','xval_data');

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.84 0.2 0.05], ...
	'String','Parameters:', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.85 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook', ...
	'String',params.visual_params, ...
	'Tag','visual_params');

help_text = 'Type the name of a data set into the "Data set" field in order to X validate the model. Leave blank if you want to use the training data. Specify the parameters';
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.60 0.72 0.15], ...
	'String',help_text, ...
	'Style','text', ...
	'Tag','StaticText1');

x_hook = 'execute_hook;';

function x_hook = draw_control(params)
	
ctrl_dir = which('control_folder');
cur_dir = cd;

occ = findstr(ctrl_dir,':');
ctrl_dir = ctrl_dir(1:occ(end));

cd(ctrl_dir);

files = dir;
for i=1:size(files,1),
	if ~strcmp(files(i).name,'control_folder.m'), 
		h1 = axes('Parent',gcf, ...
		'Units','normal', ...
		'Box','On', ...
		'XTick',[], ...
		'YTick',[], ...
		'Position',[0.26+mod(i-1,4)*0.18 0.85 - floor((i-1)/4)*0.16 0.12 0.12]);
	
		h1 = uicontrol('Parent',gcf, ...
		'Units','normal', ...
		'HorizontalAlignment','Center', ...
		'BackgroundColor',[1 1 1]*0.8, ...
		'Position',[0.25+mod(i-1,4)*0.18 0.78 - floor((i-1)/4)*0.16 0.15 0.06], ...
		'String',files(i).name(1:end-4), ...
		'Style','text', ...
		'Tag','StaticText');
		
		cmd = get_param([files(i).name(1:end-4) '/controller'], 'MaskDisplay');
	end
end

cd(cur_dir);

x_hook = 'execute_hook;';	

function x_hook = draw_stability(params)

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'ForegroundColor',[0.5 0.5 0.5], ...
	'Position',[0.23 0.5 0.76 0.49], ...
	'Style','frame', ...
	'Tag','Frame1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.25 0.91 0.2 0.05], ...
	'Style','radiobutton', ...
	'Callback','edit_hook', ...         %calls back for saving the params
	'String','LMI', ...           		%saves the inputs in a variable for later use
	'Value',params.lmi, ...
	'Tag','lmi');

h2 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.5 0.91 0.2 0.05], ...
	'Style','radiobutton', ...
	'Callback','edit_hook', ...         %calls back for saving the params
	'String','Conicity', ...           		%saves the inputs in a variable for later use
	'Value',params.coni, ...
	'Tag','coni');

h3 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.75 0.91 0.2 0.05], ...
	'Style','radiobutton', ...
	'Callback','edit_hook', ...         %calls back for saving the params
	'String','Frequency', ...           		%saves the inputs in a variable for later use
	'Value',params.freq, ...
	'UserData',[h1;h2], ...
	'Tag','freq');

set(h1,'UserData', [h2;h3]);
set(h2,'UserData', [h1;h3]);

h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.25 0.84 0.2 0.05], ...
	'Style','checkbox', ...
	'Callback','edit_hook', ...         %calls back for saving the params
	'String','With cont.', ...           		%saves the inputs in a variable for later use
	'Value',params.cc, ...
	'Tag','cc');

h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.85 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook', ...
	'String',params.cont, ...
	'Tag','input');

h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'HorizontalAlignment','Left', ...
	'Position',[0.25 0.77 0.2 0.05], ...
	'String','Data File:', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.78 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook', ...
	'String',params.dat, ...
	'Tag','dat');
	
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'HorizontalAlignment','Left', ...
	'Position',[0.25 0.71 0.2 0.05], ...
	'String','Mdl Frq. Analysis:', ...
	'Style','text', ...
	'Tag','StaticText1');
	
h1 = uicontrol('Parent',gcf, ...
	'BackgroundColor',[1 1 1], ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'Position',[0.47 0.72 0.5 0.05], ...
	'Style','edit', ...
	'Callback','edit_hook', ...
	'String',params.sist, ...
	'Tag','sist');

help_text = 'This is the FAST toolbox. Check the FAST documentation for more details.';
h1 = uicontrol('Parent',gcf, ...
	'Units','normal', ...
	'HorizontalAlignment','Left', ...
	'BackgroundColor',[1 1 1]*0.8, ...
	'Position',[0.25 0.60 0.72 0.10], ...
	'String',help_text, ...
	'Style','text', ...
	'Tag','StaticText1');

x_hook = 'execute_hook;';
