function f=my_waitbar(f,x,name)

x = max(0,min(100*x,100));
	 
if f==-1,

	oldRootUnits = get(0,'Units');

	 set(0, 'Units', 'points');
	 pos = get(0,'ScreenSize');
	 pointsPerPixel = 72/get(0,'ScreenPixelsPerInch');
	 
	 width = 360 * pointsPerPixel;
	 height = 75 * pointsPerPixel;
	 pos = [pos(3)/2-width/2 pos(4)/2-height/2 width height];

	 f = figure(...
		 'Units', 'points', ...
		 'Position', pos, ...
		 'Resize','off', ...
		 'CreateFcn','', ...
		 'NumberTitle','off', ...
		 'IntegerHandle','off', ...
		 'MenuBar', 'none', ...
		 'Tag','TMWWaitbar');
		 
	colormap([]);
	h = axes('XLim',[0 100],'YLim',[0 1]);
	set(h, ...
	 'Box','on', ...
	 'Position',[.05 .3 .9 .2],...
	 'XTickMode','manual',...
	 'YTickMode','manual',...
	 'XTick',[],...
	 'YTick',[],...
	 'XTickLabelMode','manual',...
	 'XTickLabel',[],...
	 'YTickLabelMode','manual',...
	 'YTickLabel',[]);
	
	if (nargin>2)&~isempty(name),
		title(name);
	end
	
	xline = [100 0 0 100 100];
   	yline = [0 0 1 1 0];
   	p = patch([0 x x 0]*100,[0 0 1 1],'b','EdgeColor','b','EraseMode','none');
   	l = line(xline,yline,'EraseMode','none');
   	set(l,'Color',get(gca,'XColor'));

  	set(f,'HandleVisibility','callback');
   
   	set(0, 'Units', oldRootUnits);   
	set(f,'UserData',[p l]);
	
else
	h=get(f,'UserData');
	p=h(1);
	l=h(2);
	
	xpatch = get(p,'XData');
   	xpatch = [xpatch(2) x x xpatch(2)];
   	set(p,'XData',xpatch')
   	xline = get(l,'XData');
   	set(l,'XData',xline);
	drawnow;
end
