function gifgen(file)
%GIFGEN Generate a series of gif latex formulas from a
%    deffinition file
%    
%    GIFGEN(F) Use file F to generate formulas. %
%    
%    See also: 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Generate a series of gif latex formulas from a deffinition file
%
%   @synopsis	gifgen(f)
%   @description  Use file <CODE>f</CODE> to generate formulas.
%%
%   @see 
%
%MAN_PAGE_END

fid = fopen(file);

s = fscanf(fid,'%c');count = 1;

fclose(fid);

flag = 1;

f = figure;
a = axes;
set(a,'position',[0 0 1 1]);
set(a,'units','pixels');

xy = get(a,'position');
axis([xy(1) xy(3) xy(2) xy(4)]);
x = xy(3)/2;
y = xy(4)/2;
while (flag)
	[tex,s] = strtok(s,[9 13 10]);
	[jpeg,s] = strtok(s,[9 13 10]);
	flag = ~isempty(tex);
	if flag,
		cla
		t = text(x,y,tex);
		set(t,'horizontalalignment','center');
		set(t,'fontsize',14);
		r = get(t,'extent');
		[xap,map] = capture;
		siz = size(xap);
		eq = xap(siz(1) - (floor(r(2)) + ceil(r(4)+1)):siz(1) - floor(r(2)),floor(r(1)):floor(r(1)) + ceil(r(3)) + 1);
		imwrite(eq,map,jpeg,'jpg');
	end
	
end
